CREATE TABLE Fournisseur(
   numFourn INT,
   nomFour VARCHAR(50),
   telFour INT,
   rueFour VARCHAR(50),
   cpFour INT,
   villeFour VARCHAR(50),
   PRIMARY KEY(numFourn)
)ENGINE=INNODB;

CREATE TABLE Centre(
   CodeCentre VARCHAR(50),
   NomCentre VARCHAR(50),
   PRIMARY KEY(CodeCentre)
)ENGINE=INNODB;

CREATE TABLE Famille(
   CodeFamille INT,
   NomFamille VARCHAR(50),
   PRIMARY KEY(CodeFamille)
)ENGINE=INNODB;

CREATE TABLE materiel(
   CodeMateriel VARCHAR(50),
   NomMateriel VARCHAR(50),
   PrixAchat DOUBLE,
   DateAchat DATETIME,
   DureeGarantie INT,
   CodeCentreUtilisateur VARCHAR(50),
   numFourn INT NOT NULL,
   CodeCentre VARCHAR(50) NOT NULL,
   CodeFamille INT NOT NULL,
   PRIMARY KEY(CodeMateriel),
   FOREIGN KEY(numFourn) REFERENCES Fournisseur(numFourn),
   FOREIGN KEY(CodeCentre) REFERENCES Centre(CodeCentre),
   FOREIGN KEY(CodeFamille) REFERENCES Famille(CodeFamille)
)ENGINE=INNODB;

CREATE TABLE panne(
   noPanne INT,
   datePanne DATETIME NOT NULL,
   nature VARCHAR(50) NOT NULL,
   dateReparation DATETIME,
   montant DOUBLE,
   numFourn INT,
   CodeMateriel VARCHAR(50) NOT NULL,
   PRIMARY KEY(noPanne),
   FOREIGN KEY(numFourn) REFERENCES Fournisseur(numFourn),
   FOREIGN KEY(CodeMateriel) REFERENCES materiel(CodeMateriel)
)ENGINE=INNODB;
